import React from 'react';

interface CardItem {
  icon: string;
  number: string;
  caption: string;
  bgColor: string;
  iconColor: string;
  numberColor: string;
}

const InfoCards = () => {
  const cards: CardItem[] = [
    {
      icon: '✓',
      number: '100%',
      caption: 'Free Forever',
      bgColor: 'bg-blue-100',
      iconColor: 'text-blue-600',
      numberColor: 'text-blue-600'
    },
    {
      icon: '👥',
      number: '10,000+',
      caption: 'Trusted Users',
      bgColor: 'bg-cyan-100',
      iconColor: 'text-cyan-600',
      numberColor: 'text-cyan-600'
    },
    {
      icon: '🧮',
      number: '13',
      caption: 'Smart Calculators',
      bgColor: 'bg-purple-100',
      iconColor: 'text-purple-600',
      numberColor: 'text-purple-600'
    },
    {
      icon: '⚡',
      number: '<1s',
      caption: 'Instant Results',
      bgColor: 'bg-indigo-100',
      iconColor: 'text-indigo-600',
      numberColor: 'text-indigo-600'
    }
  ];

  return (
    <div className="w-full py-16 px-4">
      <div className="max-w-7xl mx-auto">
        {/* Main Container */}
        <div className="bg-gradient-to-br from-blue-50 via-purple-50 to-pink-50 rounded-3xl shadow-xl p-8 md:p-12 border border-gray-100">
          {/* Grid Layout - Responsive */}
          <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
            {cards.map((card, index) => (
              <div
                key={index}
                className="flex flex-col items-center text-center space-y-4 group hover:scale-105 transition-transform duration-300"
              >
                {/* Icon Container */}
                <div className={`${card.bgColor} w-20 h-20 rounded-2xl flex items-center justify-center shadow-lg group-hover:shadow-xl transition-shadow duration-300`}>
                  <span className={`text-4xl ${card.iconColor}`}>{card.icon}</span>
                </div>

                {/* Number */}
                <h3 className={`text-4xl md:text-5xl font-black ${card.numberColor} tracking-tight`}>
                  {card.number}
                </h3>

                {/* Caption */}
                <p className="text-gray-700 font-semibold text-base md:text-lg">
                  {card.caption}
                </p>
              </div>
            ))}
          </div>
        </div>
      </div>
    </div>
  );
};

export default InfoCards;
