import { LeaderboardAd, InContentAd } from '@/components/ads/AdBanner';

export const metadata = {
  title: 'Privacy Policy - SA PLUK',
  description: 'Read the Privacy Policy for SA PLUK to understand how we collect, use, and protect your information.',
};

export default function PrivacyPage() {
  return (
    <div className="space-y-8">
      <div className="bg-gradient-to-r from-blue-600 to-blue-800 text-white py-12 rounded-lg shadow-lg">
        <div className="container mx-auto px-4">
          <h1 className="text-3xl md:text-4xl font-bold mb-2">Privacy Policy</h1>
          <p className="text-white/90">Effective date: {new Date().getFullYear()}-01-01</p>
        </div>
      </div>

      <LeaderboardAd />

      <div className="container mx-auto px-4">
        <div className="bg-white rounded-xl shadow-md p-6 md:p-8 prose max-w-none">
          <p>
            This Privacy Policy explains how SA PLUK ("we", "us", or "our") collects, uses, discloses, and safeguards your information when you use our website and services.
          </p>

          <h2>Information We Collect</h2>
          <ul>
            <li>Usage data such as pages visited, time on site, and interactions (via analytics tools).</li>
            <li>Contact information you voluntarily provide through forms (e.g., name, email).</li>
            <li>Technical data such as IP address, browser type, and device characteristics.</li>
          </ul>

          <h2>How We Use Your Information</h2>
          <ul>
            <li>To provide, operate, and improve our calculators and services.</li>
            <li>To respond to your inquiries and provide customer support.</li>
            <li>For analytics, research, and site optimization.</li>
            <li>To comply with legal obligations.</li>
          </ul>

          <h2>Cookies and Tracking</h2>
          <p>
            We use cookies and similar tracking technologies (including Google Analytics and advertising cookies) to understand usage and deliver relevant content. You may control cookies through your browser settings.
          </p>

          <h2>Advertising</h2>
          <p>
            We display ads through third-party providers such as Google AdSense. These providers may use cookies to serve personalized ads based on your visits to our site and other sites. You can opt out of personalized advertising through your Google Ads settings.
          </p>

          <h2>Data Sharing</h2>
          <p>
            We do not sell your personal information. We may share information with service providers who assist in our operations (e.g., analytics, hosting) under confidentiality obligations, or when required by law.
          </p>

          <h2>Data Security</h2>
          <p>
            We implement reasonable technical and organizational measures to protect your information. However, no method of transmission or storage is 100% secure.
          </p>

          <h2>Your Choices</h2>
          <ul>
            <li>Opt out of analytics via browser settings or opt-out tools.</li>
            <li>Disable cookies in your browser (may affect site functionality).</li>
            <li>Contact us to update or delete information you provided.</li>
          </ul>

          <h2>Children's Privacy</h2>
          <p>
            Our services are not directed to children under 13. We do not knowingly collect personal information from children.
          </p>

          <h2>International Data Transfers</h2>
          <p>
            If you access the site from outside the United States, you consent to the transfer of your information to the United States and other jurisdictions where our service providers operate.
          </p>

          <h2>Changes to This Policy</h2>
          <p>
            We may update this Privacy Policy from time to time. The "Effective date" above reflects the latest revision. Continued use of the site constitutes acceptance of changes.
          </p>

          <h2>Contact Us</h2>
          <p>
            If you have questions about this Privacy Policy, please contact us at
            {' '}<a href="mailto:privacy@sapluk.co.za">privacy@sapluk.co.za</a>.
          </p>
        </div>
      </div>

      <InContentAd />
    </div>
  );
}
