import type { Metadata } from 'next';
import { Inter } from 'next/font/google';
import './globals.css';
import Header from '@/components/layout/Header';
import Footer from '@/components/layout/Footer';
import GoogleAnalytics from '@/components/GoogleAnalytics';
import Script from 'next/script';

const inter = Inter({ subsets: ['latin'] });

export const metadata: Metadata = {
  title: 'SA PLUK - Free Online Financial Calculators for South Africa',
  description: 'Free online financial calculators for South African users. Calculate loans, mortgages, VAT, currency conversion, and more. Make informed financial decisions with our easy-to-use tools.',
  keywords: 'SA PLUK, south africa finance, loan calculator, mortgage calculator, currency converter, VAT calculator, financial planning',
  viewport: 'width=device-width, initial-scale=1',
  robots: 'index, follow',
};

export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html lang="en">
      <head>
        <GoogleAnalytics />
        {process.env.NEXT_PUBLIC_GOOGLE_ADSENSE && process.env.NODE_ENV === 'production' && (
          <Script
            id="adsbygoogle-init"
            async
            crossOrigin="anonymous"
            strategy="afterInteractive"
            src={`https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-${process.env.NEXT_PUBLIC_GOOGLE_ADSENSE}`}
          />
        )}
      </head>
      <body className={`${inter.className} bg-gray-50`}>
        <div className="min-h-screen flex flex-col">
          <Header />
          <main className="flex-grow container mx-auto px-4 py-8">
            {children}
          </main>
          <Footer />
        </div>
      </body>
    </html>
  );
}
