import { LeaderboardAd, InContentAd } from '@/components/ads/AdBanner';

export const metadata = {
  title: 'Disclaimer - SA PLUK',
  description: 'Read the disclaimer for SA PLUK financial calculators. Understand the limitations and proper use of our tools.',
};

export default function DisclaimerPage() {
  return (
    <div className="space-y-8">
      <div className="bg-gradient-to-r from-blue-600 to-blue-800 text-white py-12 rounded-lg shadow-lg">
        <div className="container mx-auto px-4">
          <h1 className="text-3xl md:text-4xl font-bold mb-2">Disclaimer</h1>
          <p className="text-white/90">Important information about using SA PLUK calculators</p>
        </div>
      </div>

      <LeaderboardAd />

      <div className="container mx-auto px-4">
        <div className="bg-white rounded-xl shadow-md p-6 md:p-8 prose max-w-none">
          <div className="bg-yellow-50 border-l-4 border-yellow-400 p-6 mb-8">
            <h3 className="text-lg font-semibold text-yellow-800 mb-2">Important Notice</h3>
            <p className="text-sm text-yellow-700 mb-0">
              The calculators and information provided on SA PLUK are for educational and informational purposes only. 
              They should not be considered as financial, investment, tax, or legal advice.
            </p>
          </div>

          <h2>General Information</h2>
          <p>
            SA PLUK provides free online financial calculators designed to help South African users make informed financial decisions. 
            While we strive to ensure the accuracy and reliability of our calculators, we cannot guarantee that the results will be 
            error-free or applicable to your specific situation.
          </p>

          <h2>No Financial Advice</h2>
          <p>
            The information, calculations, and results provided by SA PLUK do not constitute financial, investment, tax, or legal advice. 
            Our calculators are tools designed to help you understand various financial scenarios, but they should not replace professional 
            advice from qualified financial advisors, accountants, or legal professionals.
          </p>
          <p>
            Before making any financial decisions, we strongly recommend that you:
          </p>
          <ul>
            <li>Consult with a qualified financial advisor or planner</li>
            <li>Verify all calculations independently</li>
            <li>Consider your personal financial situation and goals</li>
            <li>Review current interest rates and fees with your financial institution</li>
            <li>Understand all terms and conditions of any financial product</li>
          </ul>

          <h2>Accuracy and Reliability</h2>
          <p>
            While we make every effort to ensure that our calculators are accurate and up-to-date, we make no representations or 
            warranties of any kind, express or implied, about:
          </p>
          <ul>
            <li>The completeness, accuracy, reliability, or suitability of the information</li>
            <li>The availability or functionality of the calculators</li>
            <li>The results produced by the calculators</li>
            <li>The applicability of the results to your specific circumstances</li>
          </ul>

          <h2>Exchange Rates and Market Data</h2>
          <p>
            Our currency converter uses live exchange rates from third-party API sources. These rates are provided for informational 
            purposes only and may differ from the actual rates offered by banks, currency exchanges, or other financial institutions. 
            Exchange rates fluctuate constantly, and the rates displayed may not reflect real-time market conditions at the time of 
            your transaction.
          </p>

          <h2>South African Context</h2>
          <p>
            Many of our calculators are tailored for the South African market, including VAT calculations at 15% and other 
            South Africa-specific financial considerations. However, tax laws, interest rates, and financial regulations change 
            frequently. Always verify current rates and regulations with official sources such as:
          </p>
          <ul>
            <li>South African Revenue Service (SARS) for tax information</li>
            <li>South African Reserve Bank (SARB) for interest rate information</li>
            <li>Your financial institution for specific product rates and terms</li>
          </ul>

          <h2>Limitation of Liability</h2>
          <p>
            SA PLUK, its owners, employees, and affiliates shall not be liable for any direct, indirect, incidental, consequential, 
            or punitive damages arising from:
          </p>
          <ul>
            <li>Your use or inability to use our calculators</li>
            <li>Any errors or inaccuracies in the calculations or results</li>
            <li>Any financial decisions made based on the information provided</li>
            <li>Any losses or damages resulting from reliance on our calculators</li>
            <li>Any interruption or cessation of service</li>
          </ul>

          <h2>Third-Party Links and Services</h2>
          <p>
            Our website may contain links to third-party websites or services, including advertisements. We are not responsible 
            for the content, accuracy, or practices of these third-party sites. The inclusion of any link does not imply endorsement 
            by SA PLUK.
          </p>

          <h2>User Responsibility</h2>
          <p>
            By using SA PLUK calculators, you acknowledge and agree that:
          </p>
          <ul>
            <li>You are solely responsible for verifying all calculations and results</li>
            <li>You will not rely solely on our calculators for financial decisions</li>
            <li>You understand the limitations of automated calculators</li>
            <li>You will seek professional advice when appropriate</li>
            <li>Any reliance you place on information from SA PLUK is strictly at your own risk</li>
          </ul>

          <h2>Changes to Calculators</h2>
          <p>
            We reserve the right to modify, update, or discontinue any calculator or feature at any time without prior notice. 
            We may also update our calculation methods, formulas, or assumptions to reflect changes in financial practices or regulations.
          </p>

          <h2>No Warranty</h2>
          <p>
            SA PLUK is provided "as is" and "as available" without any warranties of any kind, either express or implied, including 
            but not limited to warranties of merchantability, fitness for a particular purpose, or non-infringement.
          </p>

          <h2>Educational Purpose</h2>
          <p>
            Our calculators are designed primarily for educational purposes to help users understand financial concepts and explore 
            different scenarios. They are not intended to replace comprehensive financial planning or professional financial advice.
          </p>

          <h2>Contact Information</h2>
          <p>
            If you have questions about this disclaimer or need clarification about any of our calculators, please contact us through 
            our <a href="/contact" className="text-blue-600 hover:underline">contact page</a>.
          </p>

          <div className="bg-blue-50 border-l-4 border-blue-400 p-6 mt-8">
            <p className="text-sm text-blue-800 mb-0">
              <strong>Last Updated:</strong> {new Date().getFullYear()}<br />
              By using SA PLUK, you acknowledge that you have read, understood, and agree to this disclaimer.
            </p>
          </div>
        </div>
      </div>

      <InContentAd />
    </div>
  );
}
