import Link from 'next/link';
import { blogPosts } from '@/data/blog-posts';
import { LeaderboardAd, InContentAd } from '@/components/ads/AdBanner';

export const metadata = {
  title: 'Financial Blog - SA PLUK',
  description: 'Read our latest articles on personal finance, saving money, investing, and financial planning in South Africa.',
  keywords: 'finance blog, money tips, south africa finance, savings tips, investment advice',
};

export default function BlogPage() {
  return (
    <div className="space-y-0">
      {/* Page Header */}
      <div className="bg-gradient-to-br from-gray-50 via-blue-50 to-purple-50 py-20 border-b-4 border-cyan-500">
        <div className="container mx-auto px-4 text-center">
          <div className="inline-block mb-4 px-4 py-2 bg-blue-600 text-white text-xs font-bold tracking-widest uppercase shadow-lg rounded-full">
            Knowledge Hub
          </div>
          <h1 className="text-5xl md:text-7xl font-black mb-6 tracking-tight text-gray-900">Financial Insights</h1>
          <div className="w-32 h-2 bg-gradient-to-r from-cyan-400 via-cyan-500 to-cyan-400 mx-auto mb-6 rounded-full"></div>
          <p className="text-xl max-w-3xl mx-auto text-gray-700 leading-relaxed">
            Expert advice and practical tips to help you master your finances in South Africa.
          </p>
        </div>
      </div>

      <LeaderboardAd />

      {/* Blog Posts Grid */}
      <div className="container mx-auto px-4 py-16">
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-10">
          {blogPosts.map((post, index) => (
            <Link
              key={post.id}
              href={`/blog/${post.slug}`}
              className="group bg-white border-2 border-gray-200 hover:border-cyan-500 transition-all duration-500 overflow-hidden hover-lift shadow-lg hover:shadow-2xl hover:-translate-y-1"
              style={{ animationDelay: `${index * 100}ms` }}
            >
              {/* Image/Icon */}
              <div className="relative bg-gradient-to-br from-gray-100 to-gray-200 p-16 text-center border-b-2 border-gray-200 group-hover:border-cyan-500 transition-colors">
                <span className="text-7xl transition-all duration-300">{post.image}</span>
                <div className="absolute top-4 right-4 bg-cyan-500 text-blue-950 px-3 py-1 text-xs font-bold tracking-wider shadow-lg">
                  {post.category}
                </div>
              </div>
              
              <div className="p-8">
                <div className="flex items-center gap-3 text-xs text-gray-500 mb-4">
                  <span>{post.date}</span>
                  <div className="w-1 h-1 bg-gray-400 rounded-full"></div>
                  <span>8 min read</span>
                </div>
                
                <h2 className="text-2xl font-black text-blue-950 mb-4 group-hover:text-cyan-600 transition-colors tracking-tight leading-tight">
                  {post.title}
                </h2>
                
                <p className="text-gray-600 text-sm mb-6 leading-relaxed line-clamp-3">
                  {post.excerpt}
                </p>
                
                <div className="flex flex-wrap gap-2 mb-6">
                  {post.tags.slice(0, 2).map((tag, index) => (
                    <span key={index} className="text-xs bg-cyan-50 text-cyan-700 px-3 py-1 font-semibold border border-cyan-200">
                      #{tag}
                    </span>
                  ))}
                </div>
                
                <div className="flex items-center justify-between pt-4 border-t border-gray-200">
                  <span className="text-xs text-gray-500 font-semibold">By {post.author}</span>
                  <div className="flex items-center gap-2 text-blue-950 group-hover:text-cyan-600 group-hover:gap-4 transition-all font-semibold">
                    <span className="text-sm font-bold">Read</span>
                    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M13 7l5 5m0 0l-5 5m5-5H6" />
                    </svg>
                  </div>
                </div>
              </div>
            </Link>
          ))}
        </div>
      </div>

      <InContentAd />

      {/* Categories */}
      <div className="bg-gray-50 py-12 rounded-lg">
        <div className="container mx-auto px-4">
          <h2 className="text-2xl font-bold text-blue-950 mb-6 text-center">Browse by Category</h2>
          <div className="flex flex-wrap justify-center gap-4">
            {['Savings', 'Credit', 'Investing', 'Tax', 'Budgeting', 'Retirement'].map((category) => (
              <button
                key={category}
                className="bg-white hover:bg-cyan-500 hover:text-blue-950 border-2 border-cyan-500 text-cyan-600 font-semibold py-2 px-6 rounded-full transition duration-300"
              >
                {category}
              </button>
            ))}
          </div>
        </div>
      </div>
    </div>
  );
}
