import { LeaderboardAd, InContentAd } from '@/components/ads/AdBanner';

export const metadata = {
  title: 'About SA PLUK - Free Online Financial Calculators',
  description: 'Learn more about SA PLUK and our mission to provide free, easy-to-use financial calculators for South Africa to help you make better money decisions.',
};

export default function AboutPage() {
  return (
    <div className="space-y-8">
      {/* Page Header */}
      <div className="bg-gradient-to-r from-blue-600 to-blue-800 text-white py-12 rounded-lg shadow-lg">
        <div className="container mx-auto px-4 text-center">
          <h1 className="text-3xl md:text-4xl font-bold mb-4">About SA PLUK</h1>
          <p className="text-xl max-w-3xl mx-auto">
            Empowering South Africans to make informed financial decisions with free, easy-to-use calculators and resources.
          </p>
        </div>
      </div>

      {/* Top Banner Ad */}
      <LeaderboardAd />

      {/* Main Content */}
      <div className="container mx-auto px-4">
        <div className="bg-white rounded-xl shadow-md p-6 md:p-8">
          <div className="prose max-w-none">
            <h2>Our Mission</h2>
            <p>
              At SA PLUK, we believe that every South African deserves access to clear, accurate financial information. 
              Our mission is to demystify personal finance by providing free, easy-to-use calculators and educational 
              resources tailored for South Africa that help people make better financial decisions.
            </p>
            
            <h2>Who We Are</h2>
            <p>
              We're a team of finance enthusiasts, developers, and designers who are passionate about making financial 
              planning accessible to everyone. We understand that financial decisions can be overwhelming, and we're 
              here to help simplify the process.
            </p>
            
            <h2>Why Trust Our Calculators?</h2>
            <ul>
              <li><strong>Accuracy:</strong> Our calculators are built using standard financial formulas and regularly updated to ensure accuracy.</li>
              <li><strong>Ease of Use:</strong> We design our tools to be intuitive and user-friendly, regardless of your financial knowledge.</li>
              <li><strong>No Hidden Costs:</strong> All our tools are completely free to use, with no sign-ups or hidden fees.</li>
              <li><strong>Privacy-Focused:</strong> We don't store your personal or financial information when you use our calculators.</li>
              <li><strong>Educational:</strong> We provide detailed explanations and resources to help you understand the calculations.</li>
            </ul>
            
            <h2>Our Tools</h2>
            <p>
              We offer a wide range of financial calculators to help with various aspects of personal finance, including:
            </p>
            <ul>
              <li><strong>Loan & Mortgage Calculators:</strong> Calculate monthly payments, amortization schedules, and more.</li>
              <li><strong>Investment Calculators:</strong> Plan for retirement, calculate compound interest, and estimate investment growth.</li>
              <li><strong>Savings Calculators:</strong> Set and track savings goals for major purchases or emergencies.</li>
              <li><strong>Debt Payoff Calculators:</strong> Create a plan to become debt-free faster.</li>
              <li><strong>Budgeting Tools:</strong> Understand where your money goes and how to optimize your spending.</li>
            </ul>
            
            <h2>Our Commitment to Quality</h2>
            <p>
              We're committed to providing high-quality, reliable financial tools. Our team regularly reviews and updates 
              our calculators to ensure they meet the highest standards of accuracy and usability. We also welcome 
              feedback from our users to help us improve our tools.
            </p>
            
            <div className="bg-blue-50 p-6 rounded-lg my-8">
              <h3 className="text-xl font-semibold mb-4 text-blue-800">Disclaimer</h3>
              <p className="text-sm text-gray-700">
                The information provided by SA PLUK is for educational and informational purposes only and should not 
                be considered financial, investment, or professional advice. While we strive to provide accurate and 
                up-to-date information, we make no representations or warranties of any kind, express or implied, about 
                the completeness, accuracy, reliability, suitability, or availability with respect to the website or the 
                information, products, services, or related graphics contained on the website for any purpose. Any reliance 
                you place on such information is therefore strictly at your own risk. Before making any financial decisions, 
                we recommend consulting with a qualified financial advisor.
              </p>
            </div>
            
            <h2>Contact Us</h2>
            <p>
              We'd love to hear from you! If you have any questions, suggestions, or feedback, please don't hesitate to 
              reach out to us through our <a href="/contact" className="text-blue-600 hover:underline">contact page</a>.
            </p>
            
            <p className="mt-8 text-gray-600 text-sm">
              Thank you for choosing SA PLUK as your trusted financial calculator resource. We're here to help 
              you make smarter financial decisions every step of the way.
            </p>
          </div>
        </div>
      </div>
      
      {/* In-Content Ad */}
      <InContentAd />
      
      {/* Team Section */}
      <div className="bg-gray-50 py-12">
        <div className="container mx-auto px-4">
          <h2 className="text-2xl font-bold text-center mb-8">Meet Our Team</h2>
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            {[
              {
                name: 'Alex Johnson',
                role: 'Founder & Financial Expert',
                bio: 'With over 15 years of experience in personal finance and investment banking, Alex founded SA PLUK to make financial planning accessible to all South Africans.',
                image: '👨‍💼'
              },
              {
                name: 'Sarah Chen',
                role: 'Lead Developer',
                bio: 'Sarah brings her expertise in financial technology and software development to create intuitive, accurate financial tools for our users.',
                image: '👩‍💻'
              },
              {
                name: 'Michael Rodriguez',
                role: 'Content Strategist',
                bio: 'Michael ensures our content is clear, accurate, and helpful, making complex financial concepts easy to understand.',
                image: '📝'
              }
            ].map((member, index) => (
              <div key={index} className="bg-white p-6 rounded-lg shadow-md text-center">
                <div className="text-5xl mb-4">{member.image}</div>
                <h3 className="text-xl font-semibold">{member.name}</h3>
                <p className="text-blue-600 mb-3">{member.role}</p>
                <p className="text-gray-600 text-sm">{member.bio}</p>
              </div>
            ))}
          </div>
        </div>
      </div>
      
      {/* CTA Section */}
      <div className="bg-blue-600 text-white py-12">
        <div className="container mx-auto px-4 text-center">
          <h2 className="text-2xl font-bold mb-4">Ready to Take Control of Your Finances?</h2>
          <p className="text-lg mb-6 max-w-2xl mx-auto">
            Start using our free financial calculators today to plan for a better financial future.
          </p>
          <a 
            href="/calculators" 
            className="inline-block bg-white text-blue-700 hover:bg-blue-50 font-semibold py-3 px-8 rounded-full text-lg transition duration-300"
          >
            Explore Our Calculators
          </a>
        </div>
      </div>
    </div>
  );
}
