import type { ResponseCookies } from '../../server/web/spec-extension/cookies';
import { RedirectStatusCode } from './redirect-status-code';
declare const REDIRECT_ERROR_CODE = "NEXT_REDIRECT";
export declare enum RedirectType {
    push = "push",
    replace = "replace"
}
export type RedirectError<U extends string> = Error & {
    digest: `${typeof REDIRECT_ERROR_CODE};${RedirectType};${U};${RedirectStatusCode};`;
    mutableCookies: ResponseCookies;
};
export declare function getRedirectError(url: string, type: RedirectType, statusCode?: RedirectStatusCode): RedirectError<typeof url>;
/**
 * This function allows you to redirect the user to another URL. It can be used in
 * [Server Components](https://nextjs.org/docs/app/building-your-application/rendering/server-components),
 * [Route Handlers](https://nextjs.org/docs/app/building-your-application/routing/route-handlers), and
 * [Server Actions](https://nextjs.org/docs/app/building-your-application/data-fetching/server-actions-and-mutations).
 *
 * - In a Server Component, this will insert a meta tag to redirect the user to the target page.
 * - In a Route Handler or Server Action, it will serve a 307/303 to the caller.
 *
 * Read more: [Next.js Docs: `redirect`](https://nextjs.org/docs/app/api-reference/functions/redirect)
 */
export declare function redirect(
/** The URL to redirect to */
url: string, type?: RedirectType): never;
/**
 * This function allows you to redirect the user to another URL. It can be used in
 * [Server Components](https://nextjs.org/docs/app/building-your-application/rendering/server-components),
 * [Route Handlers](https://nextjs.org/docs/app/building-your-application/routing/route-handlers), and
 * [Server Actions](https://nextjs.org/docs/app/building-your-application/data-fetching/server-actions-and-mutations).
 *
 * - In a Server Component, this will insert a meta tag to redirect the user to the target page.
 * - In a Route Handler or Server Action, it will serve a 308/303 to the caller.
 *
 * Read more: [Next.js Docs: `redirect`](https://nextjs.org/docs/app/api-reference/functions/redirect)
 */
export declare function permanentRedirect(
/** The URL to redirect to */
url: string, type?: RedirectType): never;
/**
 * Checks an error to determine if it's an error generated by the
 * `redirect(url)` helper.
 *
 * @param error the error that may reference a redirect error
 * @returns true if the error is a redirect error
 */
export declare function isRedirectError<U extends string>(error: unknown): error is RedirectError<U>;
/**
 * Returns the encoded URL from the error if it's a RedirectError, null
 * otherwise. Note that this does not validate the URL returned.
 *
 * @param error the error that may be a redirect error
 * @return the url if the error was a redirect error
 */
export declare function getURLFromRedirectError<U extends string>(error: RedirectError<U>): U;
export declare function getRedirectTypeFromError<U extends string>(error: RedirectError<U>): RedirectType;
export declare function getRedirectStatusCodeFromError<U extends string>(error: RedirectError<U>): number;
export {};
