# South African Terminology Guide

This document outlines the South African-specific terminology used throughout the SA PLUK website.

## Currency
- **Currency Symbol**: R (South African Rand - ZAR)
- **Format**: R 1,000.00 (using en-ZA locale)
- All calculators use ZAR instead of USD

## Home Loan / Mortgage Terminology

### American Term → South African Term
- **Mortgage** → **Home Loan** or **Bond**
- **Down Payment** → **Deposit**
- **Property Tax** → **Municipal Rates** or **Rates and Taxes**
- **HOA Fees** → **Monthly Levies** or **Body Corporate Levies**
- **PMI (Private Mortgage Insurance)** → **Bond Insurance** or **Mortgage Protection Insurance**
- **Closing Costs** → **Transfer Costs** or **Bond Registration Fees**
- **Escrow** → **Trust Account**

## Retirement & Investment Terminology

### American Term → South African Term
- **401(k)** → **Retirement Annuity (RA)** or **Pension Fund**
- **IRA** → **Retirement Annuity (RA)**
- **Social Security** → **SASSA (South African Social Security Agency)** or **Government Pension**
- **Roth IRA** → **Tax-Free Savings Account (TFSA)**

## Tax Terminology

### American Term → South African Term
- **Federal Tax** → **Income Tax (PAYE - Pay As You Earn)**
- **State Tax** → **Provincial Tax** (not commonly used in SA)
- **Sales Tax** → **VAT (Value Added Tax)** - 15% in South Africa
- **IRS** → **SARS (South African Revenue Service)**
- **Tax Return** → **Tax Return** or **ITR12**
- **W-2 Form** → **IRP5 Certificate**

## Banking & Loan Terminology

### American Term → South African Term
- **Checking Account** → **Cheque Account** or **Current Account**
- **Savings Account** → **Savings Account** (same)
- **APR (Annual Percentage Rate)** → **Interest Rate** or **Annual Interest Rate**
- **Credit Score** → **Credit Score** or **Credit Rating** (from bureaus like TransUnion, Experian)
- **Refinance** → **Refinance** or **Bond Switching**

## Property & Real Estate

### American Term → South African Term
- **Realtor** → **Estate Agent** or **Property Practitioner**
- **Title** → **Title Deed** or **Deed of Transfer**
- **Homeowner's Insurance** → **Home Insurance** or **Homeowner's Insurance**
- **Condo** → **Sectional Title Property** or **Flat**
- **HOA** → **Body Corporate** or **Homeowners Association**

## Investment Terminology

### American Term → South African Term
- **Stocks** → **Shares** or **Equities**
- **Mutual Fund** → **Unit Trust**
- **Brokerage Account** → **Share Trading Account**
- **Dividend** → **Dividend** (same)
- **Capital Gains Tax** → **Capital Gains Tax (CGT)**

## General Financial Terms

### American Term → South African Term
- **Paycheck** → **Salary** or **Wage Slip**
- **Paystub** → **Payslip**
- **Direct Deposit** → **EFT (Electronic Funds Transfer)** or **Direct Deposit**
- **Wire Transfer** → **EFT** or **Immediate Payment**
- **Check** → **Cheque**

## Regulatory Bodies

- **SEC (Securities and Exchange Commission)** → **FSB (Financial Services Board)** / **FSCA (Financial Sector Conduct Authority)**
- **FDIC** → **SARB (South African Reserve Bank)** deposit insurance
- **IRS** → **SARS (South African Revenue Service)**

## Implementation Status

### ✅ Completed
- [x] Currency conversion to ZAR (R)
- [x] Home Loan Calculator terminology
- [x] Retirement Calculator (RA, Pension Fund, Provident Fund references)
- [x] VAT Calculator (15% South African rate)
- [x] Loan Calculator currency
- [x] Footer and navigation updates
- [x] Calculator descriptions and tags

### 📋 To Consider for Future Updates
- [ ] Add SARS tax brackets calculator
- [ ] Add Transfer Duty calculator (property transfer tax)
- [ ] Add PAYE calculator (income tax)
- [ ] Add UIF (Unemployment Insurance Fund) calculator
- [ ] Add Medical Aid Tax Credit calculator

## Notes for Content Writers

When creating new content or calculators:
1. Always use South African Rand (ZAR) with R symbol
2. Reference SARS for tax-related information
3. Use "home loan" or "bond" instead of "mortgage"
4. Reference South African Reserve Bank (SARB) for interest rates
5. Use local examples (e.g., Johannesburg, Cape Town property prices)
6. Reference local financial institutions (Standard Bank, FNB, Nedbank, ABSA, Capitec)
7. Use South African inflation rates (typically 3-6%)
8. Reference local retirement products (RA, Pension Fund, Provident Fund, TFSA)

## Useful South African Financial Resources

- **SARS**: www.sars.gov.za (Tax information)
- **SARB**: www.resbank.co.za (Interest rates, monetary policy)
- **JSE**: www.jse.co.za (Stock exchange)
- **National Credit Regulator**: www.ncr.org.za (Credit regulations)
- **Financial Sector Conduct Authority**: www.fsca.co.za (Financial regulation)
