# SA PLUK - Free Online Financial Calculators for South Africa

SA PLUK is a comprehensive web application providing free financial calculators tailored for South African users.

## 🌐 Website
**URL:** https://www.sapluk.co.za/

## 🧮 Features

### Available Calculators
- **Currency Converter** - Live exchange rates for 20+ currencies
- **Loan Calculator** - Calculate monthly payments and amortization schedules
- **Mortgage Calculator** - Comprehensive mortgage payment calculator with taxes and insurance
- **Interest Calculator** - Simple and compound interest calculations
- **VAT Calculator** - South African VAT (15%) calculator
- **Inflation Calculator** - Track purchasing power over time
- **Retirement Calculator** - Plan your retirement savings
- **Salary Converter** - Convert between annual salary and hourly wage
- **Loan to Income Ratio** - Calculate debt-to-income ratio
- **Net Worth Calculator** - Calculate total net worth
- **Credit Card Interest** - Calculate credit card interest payments
- **Savings Goal** - Plan to reach your financial goals

## 🚀 Getting Started

### Prerequisites
- Node.js 18+ 
- pnpm (or npm)

### Installation

```bash
# Install dependencies
pnpm install

# Run development server
pnpm dev

# Build for production
pnpm build

# Start production server
pnpm start
```

The application will be available at `http://localhost:3000`

## 🛠️ Tech Stack

- **Framework:** Next.js 14 (App Router)
- **Language:** TypeScript
- **Styling:** Tailwind CSS
- **Icons:** React Icons
- **Deployment:** Vercel (recommended)

## 📁 Project Structure

```
sapluk/
├── src/
│   ├── app/              # Next.js app directory
│   │   ├── calculators/  # Calculator pages
│   │   ├── about/        # About page
│   │   ├── contact/      # Contact page
│   │   ├── privacy-policy/ # Privacy policy
│   │   ├── terms/        # Terms of service
│   │   ├── layout.tsx    # Root layout
│   │   ├── page.tsx      # Homepage
│   │   ├── sitemap.ts    # Dynamic sitemap
│   │   └── robots.ts     # Robots.txt
│   ├── components/       # React components
│   │   ├── ads/          # Ad components
│   │   └── layout/       # Layout components
│   └── data/             # Data files
│       └── calculators.ts # Calculator definitions
├── public/               # Static assets
├── package.json
├── tsconfig.json
├── tailwind.config.ts
└── next.config.js
```

## 🌍 SEO Features

- Dynamic sitemap generation
- Robots.txt configuration
- Meta tags for all pages
- Structured data (future enhancement)
- Mobile-responsive design

## 📝 License

© 2025 SA PLUK. All rights reserved.

## 📧 Contact

For questions or support, contact us at: privacy@sapluk.co.za

## ⚠️ Disclaimer

The information provided by SA PLUK is for educational and informational purposes only and should not be considered financial, investment, or professional advice. Always consult with a qualified financial advisor before making financial decisions.
